<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van PRPM_IN405010NL - Organization Candidates Query</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>

    <pattern is-a="transmission-wrapper" id="PRPM_IN405010NL-wrapper">
        <param name="element" value="hl7:PRPM_IN405010NL"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="PRPM_IN405010NL-controlAct">
        <param name="element" value="hl7:PRPM_IN405010NL/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:PRPM_IN405010NL/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:PRPM_IN405010NL/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:PRPM_IN405010NL/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>

    <pattern>
        <title>queryByParameter</title>
        <rule context="hl7:queryByParameter">
            <assert role="error" test="hl7:organizationName or hl7:roleType"
                >Tenminste één van de parameters organizationName of roleType is verplicht</assert>
            <assert role="error" test="not(hl7:providerAddress)"
                >providerAddress niet gebruiken.</assert>
        </rule>
        <rule context="hl7:queryByParameter/hl7:responseModalityCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='R'"
                >responseModalityCode/@code moet waarde 'R' bevatten.</assert>
        </rule>
        <rule context="hl7:queryByParameter/hl7:responsePriorityCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='I'"
                >responsePriorityCode/@code moet waarde 'I' bevatten.</assert>
        </rule>
    </pattern>

    <pattern>
        <title>queryByParameter/roleType</title>
        <rule context="hl7:queryByParameter/hl7:roleType/hl7:value">
            <extends rule="CE"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.15.1060'"
                >roleType/value moet komen uit '2.16.840.1.113883.2.4.15.1060' (RoleCodeNL - zorgaanbiedertypen).
            </assert>
        </rule>
    </pattern>

    <pattern>
        <title>queryByParameter/roleStatus</title>
        <rule context="hl7:queryByParameter/hl7:roleStatus/hl7:value">
            <extends rule="CE"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.5.1068'"
                >roleStatus/value moet komen uit codeSysteem '2.16.840.1.113883.5.1068' (RoleStatus)</assert>
            <assert role="error" test="@code='active' or @code='terminated'"
                >roleStatus/value/@code moet de waarde ‘active’ of ‘terminated’ bevatten.</assert>
        </rule>
    </pattern>

    <pattern>
        <title>queryByParameter/lastUpdateTime</title>
        <rule context="hl7:queryByParameter/hl7:lastUpdateTime/hl7:value">
            <extends rule="IVL_TS"/>
            <assert role="error" test="count(@*)=0 and hl7:low and count(*)=1"
                >lastUpdateTime/value mag alleen een low element bevatten</assert>
        </rule>
    </pattern>
</schema>
